#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#include <Append Calibrator>
function SliderGeo()
//	variable asp

	WMAppend3DImageSlider()
	wave ImW=ImageNameToWaveRef("",WMTopImageName())
	
	variable Asp=((DimSize(ImW,0))*DimDelta(ImW,0))/(DimSize(ImW,1)*DimDelta(ImW,1))
	ModifyGraph width={Aspect,asp}
	ModifyImage $WMTopImageName() ctab= {*,*,Geo,0}
	showinfo
	
	getwindow KwTopWin, gsize
	
//	wave ImW=ImageNameToWaveRef("",WMTopImageName())
	
	
	variable ImOff
	
	ControlBar/L 30
	SetVariable OffV bodywidth=(V_bottom-V_top)*0.2,pos={-25,V_top+30},Proc=ImageOffset,Value=ImOff,title=" "
	
	
	Slider OffSet size={40,(V_Bottom-V_top)},pos={0,V_top+30+(V_bottom-V_top)*0.2},ticks=0
	Slider OffSet limits={wavemin(ImW),wavemax(ImW),1},proc=ImageOffset,value=ImOff
	
	
end

function ImageOffset(name,value,event)
	string Name
	variable value,event
	
	controlinfo Offset
	variable/G ImOff=V_value
	
	ModifyImage $WMTopImageName() ctab= {ImOff,,Geo,0}
	ModifyImage $WMTopImageName() minRGB=NaN
end

function sequentialROIZ()

	string Images=wavelist("TL*.tif",";","")
	string ROIs=wavelist("Square9*",";","")
	
	variable i
	for(i=0;i<ItemsInList(ROIs);i+=1)
		Wave w=NewPlotROIZ(Stringfromlist(i,ROIs),1,1,StringFromList(i+1,Images))
		setscale/P x,0,0.005,w
	endfor
		
	WaveAvg("Ratio*")
	

end


function GetDI() // This function is designed for step injection.
	
	string Traces=traceNameList("",";",1+4)
	variable i
	variable dI
	variable id
	
	for(i=0;i<ItemsInList(Traces);i+=1)
		id=NumberByKey("Imon",stringfromlist(i,Traces),"_")
		if(numtype(id)==2)
		else
			wave w=TraceNameToWaveRef("", stringfromlist(i,Traces))
			dI=mean(w,0.09,0.095)-mean(w,0.115,0.1195)
			printf "%s : %g\r",NameOfWave(w),dI
		endif
	endfor
end

function GetFI() //This function is also designed for step injection.
	
	string Traces=TraceNameList("",";",1+4)
	variable i
	variable FI
	variable id
	
	for(i=0;i<ItemsInList(Traces);i+=1)
//		id=NumberByKey("Imon",stringfromlist(i,Traces),"_")
//		if(numtype(id)==2)
//		else
			wave w=TraceNameToWaveRef("", stringfromlist(i,Traces))
			FI=mean(w,0.055,0.065)-mean(w,0.085,0.095)
			printf "%s : %g\r",NameOfWave(w),FI
//		endif
	endfor
end

function SampleForImage(w,dx)
	wave w
	variable dx
//	variable Pbegin=x2Pnt(w,0.1125)
//	variable Pend=x2Pnt(w,0.1675)
	variable nn=1+(0.245-0.1)/dx
	make/n=0 ResampleI
	
	variable i
	for(i=0.1+dx/2;i<0.25;i+=dx)
//		print (i-(0.1+dx/2))/dx
//		print x2pnt(w,i)
//		ReSampleI[(i-(0.1+dx/2))/dx]=mean(w,i-dx/2,i+dx/2)
		insertpoints/M=0 DimSize(ResampleI,0),1,ResampleI
		ReSampleI[DimSize(ResampleI,0)-1]= mean(w,i-dx/2,i+dx/2)
	endfor
	setscale/P x,0.1,dx,ResampleI
	
end

function GetDIo(target) //target is the duplicant of a IT trace during iontophoresis region 
	wave target

	wave w=$csrwave(A)

	variable m=(w[x2pnt(w,0.09995)]-w[pcsr(A)])/(0.09995-xcsr(A))
	variable y0=w[pcsr(A)]-m*xcsr(A)
	
	variable i
	for(i=0;i<numpnts(target);i+=1)
//		print pnt2x(target,i) 
		target[i]=target[i]-(y0+m*pnt2x(target,i))
	endfor
	 
end

function GetDFo()
	
	wave w=TraceNameToWaveRef("",stringfromlist(0,traceNameList("",";",1+4)) )
	
	duplicate/R=(0.1,0.245) w, F_ionto
	F_ionto = F_ionto - mean(w,0.065,0.095)
	F_ionto = F_ionto*-1
	
end

function GrAFitLine(mode)
	variable mode    // 0: by cursor, 1: by abitrary value

	wave W_Coef
	wave w=CsrXWaveRef(A)
	variable i	
	
	switch(mode)
		case 0:
			make/O/n=(pcsr(B)-pcsr(A)+1) Fit_Line
			for(i=0;i<numpnts(Fit_Line);i+=1)
				Fit_Line[i]=W_Coef[0]+W_Coef[1]*w[pcsr(A)+i]
			endfor			
		break
		case 1:
			make/O/n=11 Fit_Line	
			for(i=0;i<numpnts(Fit_Line);i+=1)
				Fit_Line[i]=W_Coef[0]+W_Coef[1]*(w[pcsr(A)]+i*(100e-12-w[pcsr(A)])/10)
			endfor		
		break
	endswitch	
		
	setscale/I x,w[pcsr(A)],100e-12, Fit_Line

end

function Auto3DDF()
	string aw=wavelist("TL*",";","")
	variable i
	string newname,newname2
	
	for(i=1;i<ItemsInList(aw);i+=1)
		wave w=$stringfromlist(i,aw)
		wave BGw=Fominus(1,9,w)
		wave DFw=wavecalculatorw(1,w,BGw)
		newname= NameOfWave(w)+"_DF"
		rename DFw, $NewName
		wave DFw2=$NewName
		wave w3=AvgIn3DWave(11,49,DFw2)
	endfor
	killwaves DFw

end

 Function/Wave NewPlotROIZ(ROIMaskName,ini_n,n,FileName)
    	
    	STRING ROIMaskName,FileName
    	VARIABLE n,ini_n           //tell Igor how many spot will be analyzed
    	
    	
    	string NewName,RName
    	STRING AllROI=wavelist(ROIMaskName,";","")
    	string cmd
    	String RoiName
    	VARIABLE j,k    

    	Wave BGROI
    	if(waveexists(BGROI)!=1)
    		DoAlert 0,"No background region is defined !"
    		return $""
    	endif
    	
    	variable Vini,SG

    
     	for(k=0;k<n;k+=1)
     	      RoiName= StringFromList(k+ini_n-1,AllROI,";")
     	      Make/O/N=(DimSize($FileName,2)) Avg_S
     	      Make/O/N=(DimSize($FileName,2)) Ratio_S
     	     		
     		for(j=0;j<DimSize($FileName,2);j+=1)
    	 		ImageStats/P=(j)/R=$ROIName $FileName    	 		
    	 		SG=V_avg
    	 		Avg_S[j]=SG
    	 		ImageStats/P=(j)/R=BGROI $FileName
    	 		Avg_S[j] = SG-V_avg
     		endfor
     			
     			Vini=mean(Avg_S,pnt2x(Avg_S,1),pnt2x(Avg_S,9))    /////////////////////// place which define the range of F0 //////////////
	     		Ratio_S=(Avg_S-Vini)/Vini
     		
		NewName="Avg_"+ROIName
		Rname="Ratio_"+ROIName
   	      Rename Avg_S, $NewName
	      rename Ratio_S, $RName
     	endfor
//     	killwaves BG
     // 2.on checkbox for filtering is also needed, perhaps a special box for filtering.
	return $NewName
	setdatafolder home			
	display $ROIName+"_Avg"
 
 End
 
 function GetAllLeakBack()
 	
 	LeakBack(0)
 	
 	
 	string aLeak=WaveList("*Leak_1",";","")
 	
 	variable i
 	for(i=0;i<ItemsInList(aLeak);i+=1)
 		wave Lw=$stringfromlist(i,aLeak)
 		wave Lrw=FitReplaceLeak(Lw)
 		movewave Lrw, :Plus_Leak:
 	endfor
 	
 	setdatafolder Plus_Leak
 	
 	string aImon=WaveList("uImon*",";","")
 	aLeak=WaveList("*Fit",";","")
 	string NewName
 	
 	for(i=0;i<ItemsInList(aLeak);i+=1)
 		newname="nImon_"+num2str(i)
 		wave Sw=wavecalculatorw(1,$stringfromlist(i,aImon),$stringfromlist(i,aLeak))
 		rename solution, $NewName 
 	endfor
 end